// definition file for sound.cc, (c) 1999 Pawel Jalocha

#ifdef __linux__
#include <unistd.h>
#include <sys/fcntl.h>
#endif

#ifdef __MSDOS__
#include <io.h>
#include <dos.h>
#endif

class SoundDevice
{ public:
   SoundDevice();
   ~SoundDevice();
   int OpenForRead(char *Device, int ReqRate, int NonBlock=0);
   int OpenForWrite(char *Device, int ReqRate, int NonBlock=0);
   int OpenForReadWrite(char *Device, int ReqRate, int NonBlock=0);
   int OpenFileForRead(char *FileName, int Rate, char *MonDevice=(char*)NULL);
   int OpenFileForWrite(char *FileName, int Rate, char *MonDevice=(char*)NULL);
   int Close();
   int Read(short int *Buff, int MaxSamples);
   int ReadReady();
   int Write(short int *Buff, int MaxSamples);
   int WriteReady();
  public:
   int Rate;
   int DevNo;
   int FileNo;
   long int TotalRead;
   long int TotalWritten;
  private:
   int Open(char *Device, int ReqRate, int Dir, int NonBlock=1);
} ;

#ifdef __linux__

class MixerDevice
{ public:
   MixerDevice();
   ~MixerDevice();
   int Open(char *Device);
   int Close() { int err=close(DevNo); return err ? -1 : 0; }
   int SetChanLev(int Chan, int Level);
//   int SetRecSource(int Source);

   int RecFromLine();
   int RecFromMic();
   int SetRecLevel(int Level);

   int SetMicLevel(int Level);
   int SetLineLevel(int Level);
   int SetGenRecLevel(int Level);
   int SetDigOutLevel(int Level);
   int SetVolumeLevel(int Level);
   int SetMonitorLevel(int Level);

  private:
   int DevNo;
   int RecSource; // channel we record from
} ;

#endif // __linux__